/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
import java.util.Calendar;
import java.util.Vector;

import lotus.domino.Agent;
import lotus.domino.AgentBase;
import lotus.domino.AgentContext;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.domino.Document;

/**
 * Server Basierter Agent, der durch die Methode runOnServer aufgerufen wird.
 * Demo zur Parameterbergabe und zur Auswertung von getParameterDocID
 * Code zur Verwendung in einem im Domino Designer angelegten Java Agenten.
 * (Im Java Agenten muss die package Deklaration entfernt werden.)
 * 
 * @author Thomas Ekert
 */
public class ServerBasedAgent extends AgentBase {
	
	public void NotesMain() {

		Document parameter = null;
		try {
			Session session = getSession();
			AgentContext agentContext = session.getAgentContext();
			Agent ag = agentContext.getCurrentAgent();
			Database db = agentContext.getCurrentDatabase();
			String noteID = ag.getParameterDocID();
			parameter = db.getDocumentByID(noteID);
			DateTime now = session.createDateTime(Calendar.getInstance().getTime());
			Vector val = parameter.getItemValue("F_ranOnServerTime");
			val.add(now);
			parameter.replaceItemValue("F_ranOnServerTime",val);
			String server = session.getServerName();
			server = (server == null || server.length() == 0)?"Lokal":server;
			val = parameter.getItemValue("F_ranOnServerName");
			val.add(server);
			parameter.replaceItemValue("F_ranOnServerName",val);			
			parameter.save (true,false);
			System.out.println (session.getCommonUserName());
			System.out.println (session.getCredentials());
			System.out.println (session.getUserName());
			System.out.println (session.getUserGroupNameList());
			System.out.println (session.getUserNameList());
			System.out.println (session.getUserNameObject());
			System.out.println (agentContext.getEffectiveUserName());

		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			if (parameter != null) {
				try {
					parameter.recycle();
				} catch (NotesException e1) {
					e1.printStackTrace();
				}
			}
		}
	}
}
